package com.bxm.lovelink.common.chat.coze;

import cn.hutool.core.io.IoUtil;
import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.service.auth.JWTOAuth;
import com.coze.openapi.service.auth.JWTOAuthClient;
import com.coze.openapi.service.config.Consts;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

import java.nio.charset.StandardCharsets;

/**
 * @author Allen Hu
 * @date 2025/6/30
 */
@Slf4j
public class CozeJWTOAuth implements InitializingBean {

    private final String clientId;
    private final Resource privateKeyFileResource;
    private final String publicKeyId;
    private JWTOAuthClient oauth;

    public CozeJWTOAuth(String clientId, Resource privateKeyFileResource, String publicKeyId) {
        this.clientId = clientId;
        this.privateKeyFileResource = privateKeyFileResource;
        this.publicKeyId = publicKeyId;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            byte[] bytes = IoUtil.readBytes(privateKeyFileResource.getInputStream());
            String jwtOauthPrivateKey = new String(bytes, StandardCharsets.UTF_8);
            oauth = new JWTOAuthClient.JWTOAuthBuilder()
                            .clientID(clientId)
                            .privateKey(jwtOauthPrivateKey)
                            .publicKey(publicKeyId)
                            .baseURL(Consts.COZE_CN_BASE_URL)
                            .build();
            log.info("coze oauth build success");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JWTOAuth build() {
        return JWTOAuth.builder().jwtClient(oauth).build();
    }

    public OAuthToken getAccessToken() {
        return oauth.getAccessToken();
    }

    public static void main(String[] args) throws Exception {
        FileSystemResource resource = new FileSystemResource("/Users/huxiao/Downloads/private_key.pem");
        CozeJWTOAuth jwt = new CozeJWTOAuth("1165922270501", resource, "ZwhIrDxEecP_wLLfs4P9I4z6HkF-okx6J090V9CUhCw");
        jwt.afterPropertiesSet();

        System.out.println(jwt.getAccessToken());
        System.out.println(jwt.getAccessToken());
        System.out.println(jwt.getAccessToken());
    }
}
