package com.bxm.lovelink.common.chat.coze;

import com.alibaba.fastjson.JSONObject;
import com.bxm.lovelink.common.chat.Attachment;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.client.connversations.message.model.MessageContentType;
import com.coze.openapi.client.connversations.message.model.MessageObjectString;
import com.coze.openapi.service.utils.Utils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/6/30
 */
@Component
public class ImageTextMessageConvert implements MessageConvert {
    @Override
    public int contentType() {
        return Constants.Chat.CONTENT_TYPE_TEXT_IMAGE;
    }

    @Override
    public boolean ignore() {
        return false;
    }

    @Override
    public Message convert(ChatSessionMessage message) {
        Message e = new Message();

        String content = message.getContent();
        String attachments = message.getAttachments();
        List<Attachment> attachmentList = null;
        if (StringUtils.isNotBlank(attachments)) {
            attachmentList = JSONObject.parseArray(attachments, Attachment.class);
        }
        if (CollectionUtils.isNotEmpty(attachmentList)) {
            // 多模态内容
            List<MessageObjectString> contents = Lists.newArrayList();
            MessageObjectString text = MessageObjectString.buildText(content);
            contents.add(text);

            for (Attachment attachVo : attachmentList) {
                MessageObjectString image = MessageObjectString.buildImageByURL(attachVo.getUrl());
                contents.add(image);
            }

            e.setContentType(MessageContentType.OBJECT_STRING);
            e.setContent(Utils.toJson(contents));
        } else {
            // 纯文本
            e.setContentType(MessageContentType.TEXT);
            e.setContent(content);
        }
        return e;
    }
}
