package com.bxm.lovelink.common.chat.coze;

import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.client.connversations.message.model.MessageContentType;
import org.springframework.stereotype.Component;

/**
 * @author Allen Hu
 * @date 2025/6/30
 */
@Component
public class TextMessageConvert implements MessageConvert {
    @Override
    public int contentType() {
        return Constants.Chat.CONTENT_TYPE_TEXT;
    }

    @Override
    public boolean ignore() {
        return false;
    }

    @Override
    public Message convert(ChatSessionMessage message) {
        Message e = new Message();
        // 纯文本
        e.setContentType(MessageContentType.TEXT);
        e.setContent(message.getContent());
        return e;
    }
}
