package com.bxm.lovelink.common.contant;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author huxiao
 * @date 2024/3/15
 * @since 1.0.0
 */
public interface Constants {

    int MAX_PAGE_SIZE = 100;

    /**
     * 逻辑删除，未删除
     */
    int NOT_DELETED = 0;
    /**
     * 逻辑删除，已删除
     */
    int DELETED = 1;

    /**
     * 不强制更新
     */
    int not_update = 0;
    /**
     * 强制更新
     */
    int update = 1;

    /**
     * 启用状态
     */
    int STATUS_OPEN = 1;
    /**
     * 禁用状态
     */
    int STATUS_CLOSE = 0;


    int YES = 1;
    int NO = 0;

    int PARENT_CODE = 0;

    String AI_NICK_NAME = "红娘暖暖";
    /**
     * 发放推广奖励资料完善度达标值
     */
    int INFO_COMPLETION_THRESHOLD = 80;

    /**
     * 滑动次数过期时间 秒
     */
    Long SWIPE_EXPIRE_TIME_IN_SECONDS = 86400L;

    Integer ONE = 1;


    enum TemplateEnum {
        ONE(1, "特质模版"),
        TWO(2, "资料模版"),
        THREE(3, "社交模版"),
        FOUR(4, "付费模版");
        private final int value;
        private final String desc;

        TemplateEnum(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public static String getDescByValue(int value) {
            for (TemplateEnum e : values()) {
                if (e.value == value) {
                    return e.desc;
                }
            }
            return null;
        }
    }

    interface MeetGroupConst {
        /**
         * 见面需要的红豆数量
         */
        int MEET_NEED_TICKET_COUNT = 100;

        /**
         * VIP用户发起见面允许减少的相亲券数量
         */
        int VIP_REDUCTION_TICKET_COUNT = 1;

        /**
         * 邀约后超时时间，小时。
         */
        int INVITE_EXPIRE_TIME_HOUR = 48;

        int READ_MARK_YES = 1;

        int READ_MARK_NO = 0;

        /**
         * 见面群状态
         */
        enum GroupStatus {

            /**
             * 拒绝
             */
            REJECT(-1),
            /**
             * 举报
             */
            WHISTLE(-2),
            /**
             * 超时
             */
            TIMEOUT(-3),
            /**
             * 等待接受
             */
            WAIT_ACCEPT(0),
            /**
             * 同意，进入沟通中(见面中)
             */
            ACCEPT(1),
            /**
             * 没有见面?
             */
            @Deprecated
            NO_MEET(2),
            /**
             * 见面成功
             */
            MEET_SUCCESS(3),
            /**
             * 见面失败
             */
            @Deprecated
            MEET_FAIL(4);

            private final int value;

            GroupStatus(int value) {
                this.value = value;
            }

            public int value() {
                return value;
            }
        }

        enum MeetAddressStatus {
            WAIT_SELECT(0),
            WAIT_CONFIRM(1),
            CONFIRM(2);
            private final int value;

            MeetAddressStatus(int value) {
                this.value = value;
            }

            public int value() {
                return value;
            }
        }

        /**
         * 见面反馈结果
         */
        enum MeetResult {
            NOT_MEET(0),
            MEET(1);
            private final int value;

            MeetResult(int value) {
                this.value = value;
            }

            public int value() {
                return value;
            }
        }
    }

    interface MeetGroupMessageConst {

        String ROLE_USER = "user";
        String ROLE_ASSISTANT = "assistant";

        /**
         * 文本消息
         */
        Integer CONTENT_TYPE_TEXT = 1;
    }

    /**
     * 用户关系类型
     */
    @Getter
    enum UserRelationType {
        NO_FEELING(0),
        HEARTBEAT(1),
        DISLIKE(2);
        private final Integer type;

        UserRelationType(Integer type) {
            this.type = type;
        }

    }

    interface PairKey {
        String REGISTER_PAGE_CONFIG = "register_page_config";
        String FINISH_BASIC_INFO_PAGE_CONFIG = "finish_basic_info_page_config";

        String HUAWEI_OMP_RELATION_NUMBERS = "huawei_omp_relation_numbers";

        String DOWNLOAD_URL = "download_url";

        String INTERNAL_IP_LIST = "internal_ip_list";
        String MEET_TICKET_CONFIG = "meet_ticket_config";
        String APPLE_RECEIPT_URL = "apple_receipt_url";
        String APPLE_PRODUCT_ID = "apple_product_id";
        String USER_INFO_BODY_SHAPE = "user_info_body_shape";

        String INVITE_CONFIG = "invite_config";
        /**
         * 推送场景
         */
        String USER_PUSH_SCENE = "task_scene";

        String NEW_USER_RULE = "new_user_rule";
        /**
         * 插入卡片配置
         */
        String INSERT_CARD_CONFIG = "insert_card_config";

        /**
         * 赠送免费报名机会的活动类型 id
         */
        String FREE_REGISTRATION_ACTIVITY_TYPE_ID = "free_registration_activity_type_id";

        /**
         * 活动支付配置
         */
        String ACTIVITY_PAY_CONFIG = "activity_pay_config";
    }

    interface TaskType {
        /**
         * 即时，立刻，马上
         */
        int IMMEDIATELY = 1;
        /**
         * 定时
         */
        int TIMMER = 2;
    }

    interface RegistrationResult {
        /**
         * 成功
         */
        int SUCCESS = 0;
        /**
         * 失败-名额已满
         */
        int FULL = 1;
        /**
         * 早鸟票售罄
         */
        int DISCOUNT_SOLD_OUT = 2;
        /**
         * 存在未支付订单
         */
        int EXIST_UNPAID_ORDER = 3;

    }

    interface UserOrder {
        int STATUS_WAIT_FOR_PAY = 0;
        int STATUS_PAYING = 1;
        int STATUS_SUCCESS = 2;
        int STATUS_CLOSED = 3;
        int STATUS_CANCEL = 4;
        int STATUS_REFUNDING = 5;
        int STATUS_REFUND_SUCCESS = 6;
        int STATUS_REFUND_FAIL = 7;

        interface PayType {
            int ALI_PAY = 1;
            int WX_PAY = 2;
            int APPLE_PAY = 3;
        }

        interface ExtJsonKey {
            /**
             * 红豆有效天数 (int)
             */
            String TICKET_VALID_DAYS = "ticketValidDays";

            /**
             * vip有效天数（int）
             */
            String VIP_VALID_DAYS = "vipValidDays";

            /**
             * vip过期时间 (string:yyyy-MM-dd HH:mm:ss)
             */
            String VIP_EXPIRE_TIME = "vipExpireTime";
        }
    }

    interface MeetTicketProduct {
        /**
         * 普通次卡
         */
        int NORMAL = 1;
        /**
         * VIP卡
         */
        int VIP = 2;
        /**
         * 付费认证
         */
        int CERT_PAY = 3;
        /**
         * 活动付费
         */
        int ACTIVITY_PAY = 4;
    }


    interface UserMeetTicket {
        /**
         * 可用
         */
        int STATUS_AVAILABLE = 1;
        /**
         * 已使用
         */
        int STATUS_USED = 2;
        /**
         * 冻结
         */
        int STATUS_FREEZE = 3;

        int TICKET_VALID_DAYS = 3 * 365;
        /**
         * 退回红豆比例
         */
        double RETURN_RATE = 0.8;
    }

    interface MeetTicketRecord {
        // 分类 1.充值 2.支出 3.退回
        int CATEGORY_CHARGE = 1;
        int CATEGORY_USE = 2;
        int CATEGORY_RETURN = 3;
    }

    /**
     * 用户性别
     */
    interface UserGender {
        int MALE = 1;
        int FEMALE = 0;
    }

    /**
     * 心动渠道
     */
    interface HeartBeatChannel {
        int HOME = 1;
        int LIST = 2;
    }

    /**
     * 滑动限制状态
     */
    interface SwipeLimitStatus {
        int OUT_OF_LIMIT = -1;
        int REACH_LIMIT = 0;
        int NORMAL = 1;
    }

    /**
     * 学历认证结果等级
     */
    interface EducationCertResultLevel {
        String DOCTOR = "博士研究生";
        String MASTER = "硕士研究生";
        String BACHELOR = "本科";
        String JUNIOR_COLLEGE = "专科";
        String NIGHT_COLLEGE = "夜大电大";
        String OTHER = "其他";
    }

    static Integer mapEducationLevel(String level) {
        if (StringUtils.isBlank(level)) {
            return null;
        }
        switch (level) {
            case EducationCertResultLevel.JUNIOR_COLLEGE:
                return UserConstants.EduHighestEnum.JUNIOR_COLLEGE.getCode();
            case EducationCertResultLevel.BACHELOR:
            case EducationCertResultLevel.NIGHT_COLLEGE:
                return UserConstants.EduHighestEnum.BACHELOR.getCode();
            case EducationCertResultLevel.MASTER:
                return UserConstants.EduHighestEnum.MASTER.getCode();
            case EducationCertResultLevel.DOCTOR:
                return UserConstants.EduHighestEnum.DOCTOR.getCode();
        }
        return UserConstants.EduHighestEnum.NO_PREFERENCE.getCode();
    }

    /**
     * 卡片类型
     */
    interface CardType {
        int GUIDE_CARD = 1;
        int INVITE = 2;
        int REAL_NAME = 3;
    }

    /**
     * 卡片具体类型
     */
    interface CardSubType {
        int USER_INFO_COMPLETE = 1;
        int INVITE = 2;
        int REAL_NAME = 3;
    }

    /**
     * 卡片滑动效果
     */
    interface SwipeEffect {
        int ALLOW_SWIPE = 0;
        int REBOUNCE = 1;
        int FIXED = 2;
    }

    /**
     * 活动报名状态
     */
    interface ActivityRegistrationStatus {
        int WAIT_PAY = 0;
        int TIMEOUT_NOT_PAY = 1;
        int SUCCESS = 2;
        int REFUND = 3;
    }

    /**
     * 早鸟票方式：1-日期 2-名额
     */
    interface DiscountLimitType {
        int DATE = 1;
        int COUNT = 2;
    }

    /**
     * 活动签到状态 0未签到 1 已签到
     */
    interface ActivitySignStatus {
        int NOT_SIGN = 0;
        int SIGNED = 1;
    }

    /**
     * 活动状态 0 关闭  1开启
     */
    interface ActivityStatus {
        int CLOSE = 0;
        int OPEN = 1;
    }

    /**
     * 活动状态 0-未开始 1-进行中 2-已结束 3-名额已满 4-报名已结束
     */
    interface ActivityProgressStatus {
        int NOT_START = 0;
        int IN_PROGRESS = 1;
        int END = 2;
        int FULL = 3;
        int REGISTER_END = 4;
        int REGISTERING = 5;
    }

    /**
     * 活动排序状态 0-进行中 1-已报名 2-马上报名 3-名额已满 4-报名已结束 5-已结束
     */
    interface ActivitySortStatus{
        int IN_PROGRESS = 0;
        int REGISTERED = 1;
        int REGISTERING = 2;
        int FULL = 3;
        int REGISTER_END = 4;
        int END = 5;
    }

    /**
     * 活动公开状态 0 非公开  1公开
     */
    interface ActivityOvertStatus {
        int NOT_OVERT = 0;
        int OVERT = 1;
    }

    /**
     * 活动业务类型
     */
    interface ActivityBizType {
        int OTHER = 0;
        int MUTUAL_SELECTION = 1;
    }

    interface Chat {
        String ROLE_USER = "user";
        String ROLE_ASSISTANT = "assistant";
        String ROLE_SYSTEM = "system";
        String ROLE_STAFF = "staff";
        String ROLE_UI = "ui";

        /**
         * 截断符号
         */
        int CONTENT_TYPE_SPLIT_SYMBOL = 0;
        /**
         * 文本消息
         */
        int CONTENT_TYPE_TEXT = 1;
        /**
         * 图文消息
         */
        int CONTENT_TYPE_TEXT_IMAGE = 2;
        /**
         * 用户卡片
         */
        int CONTENT_TYPE_USER_CARD = 3;

        /**
         * 0 AI对接中
         */
        int CHAT_CONTACT_ROLE_AI = 0;
        /**
         * 1 人类接管中
         */
        int CHAT_CONTACT_ROLE_HUMAN = 1;
        /**
         * 人工用户id
         */
        long STAFF_USER_ID = 0;
        /**
         * 企微默认用户id
         */
        long WECOM_DEFAULT_USER_ID = -9;

        /**
         * 场景类型-默认
         */
        int SCENE_TYPE_DEFAULT = 1;
        /**
         * 场景类型-企微
         */
        int SCENE_TYPE_WECOM = 2;
    }

    interface HeartBeatTab {
        /**
         * 心动我的
         */
        int HEART_BEAT_ME = 1;
        /**
         * 访客
         */
        int VISITOR = 2;
        /**
         * 我的心动
         */
        int MY_HEART_BEAT = 3;
    }

    interface UserBasicInfoFinishStage {
        /**
         * 昵称头像
         */
        int NICKNAME_AVATAR = 1;
        /**
         * 图片
         */
        int ALBUM = 2;
        /**
         * 基础六项
         */
        int BASIC_SIX = 4;
        /**
         * 认证
         */
        int CERT = 8;
        /**
         * 理想伴侣
         */
        int LOVE_CONDITION = 16;
    }

}
