package com.bxm.lovelink.common.dal.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.handler.GuestRecommendTypeHandler;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动表
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "activity", autoResultMap = true)
public class Activity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 头图
     */
    private String headImage;

    /**
     * 城市code
     */
    private String cityCode;

    /**
     * 活动类型ID
     */
    private Long activityTypeId;

    /**
     * 活动负责人ID
     */
    private Long organizerId;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动简介
     */
    private String intro;

    /**
     * 新用户免费 0-否 1-是
     */
    private Integer newUserFree;

    /**
     * 报名费用
     */
    private BigDecimal registerPrice;

    /**
     * 早鸟票价
     */
    private BigDecimal discountPrice;

    /**
     * 早鸟票方式：1-日期 2-名额
     */
    private Integer discountLimitType;

    /**
     * 早鸟票开始时间
     */
    private LocalDateTime discountStartTime;

    /**
     * 早鸟票结束时间
     */
    private LocalDateTime discountEndTime;

    /**
     * 早鸟票限制名额
     */
    private Integer discountLimitCount;

    /**
     * 早鸟票已报名人数
     */
    private Integer discountRegisterCount;

    /**
     * 活动开始时间
     */
    private LocalDateTime activityStartTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime activityEndTime;

    /**
     * 活动报名开始时间
     */
    private LocalDateTime registerStartTime;

    /**
     * 活动报名结束时间
     */
    private LocalDateTime registerEndTime;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 详细活动地址
     */
    private String addressDetail;

    /**
     * 活动上限人数
     */
    private Integer participantsLimit;

    /**
     * 男生上限人数
     */
    private Integer maleParticipantsLimit;

    /**
     * 女生上限人数
     */
    private Integer femaleParticipantsLimit;

    /**
     * 男生报名人数
     */
    private Integer maleRegisteredCount;

    /**
     * 女生报名人数
     */
    private Integer femaleRegisteredCount;

    /**
     * 活动介绍图片 list类型的json字符串
     */
    private String introImages;

    /**
     * 封面图片 list类型的json字符串
     */
    private String coverImages;

    /**
     * 活动流程图片 list类型的json字符串
     */
    private String flowImages;

    /**
     * 退款规则图片 list类型的json字符串
     */
    private String refundPolicyImages;

    /**
     * 注意事项图片 list类型的json字符串
     */
    private String noticeImages;

    /**
     * 企微二维码 list类型的json字符串
     */
    private String wecomQrCode;

    /**
     * 嘉宾推荐
     */
    @TableField(typeHandler = GuestRecommendTypeHandler.class)
    private GuestRecommend guestRecommend;

    /**
     * 活动状态 0 关闭  1开启
     */
    private Integer activityStatus;

    /**
     * 活动可见范围： 0 私有 1公开
     */
    private Integer overtStatus;

    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String HEAD_IMAGE = "head_image";

    public static final String CITY_CODE = "city_code";

    public static final String ACTIVITY_TYPE_ID = "activity_type_id";

    public static final String ORGANIZER_ID = "organizer_id";

    public static final String NAME = "name";

    public static final String TITLE = "title";

    public static final String INTRO = "intro";

    public static final String NEW_USER_FREE = "new_user_free";

    public static final String REGISTER_PRICE = "register_price";

    public static final String DISCOUNT_PRICE = "discount_price";

    public static final String DISCOUNT_LIMIT_TYPE = "discount_limit_type";

    public static final String DISCOUNT_START_TIME = "discount_start_time";

    public static final String DISCOUNT_END_TIME = "discount_end_time";

    public static final String DISCOUNT_LIMIT_COUNT = "discount_limit_count";

    public static final String DISCOUNT_REGISTER_COUNT = "discount_register_count";

    public static final String ACTIVITY_START_TIME = "activity_start_time";

    public static final String ACTIVITY_END_TIME = "activity_end_time";

    public static final String REGISTER_START_TIME = "register_start_time";

    public static final String REGISTER_END_TIME = "register_end_time";

    public static final String ADDRESS = "address";

    public static final String ADDRESS_DETAIL = "address_detail";

    public static final String PARTICIPANTS_LIMIT = "participants_limit";

    public static final String MALE_PARTICIPANTS_LIMIT = "male_participants_limit";

    public static final String FEMALE_PARTICIPANTS_LIMIT = "female_participants_limit";

    public static final String MALE_REGISTERED_COUNT = "male_registered_count";

    public static final String FEMALE_REGISTERED_COUNT = "female_registered_count";

    public static final String INTRO_IMAGES = "intro_images";

    public static final String COVER_IMAGES = "cover_images";

    public static final String FLOW_IMAGES = "flow_images";

    public static final String REFUND_POLICY_IMAGES = "refund_policy_images";

    public static final String NOTICE_IMAGES = "notice_images";

    public static final String WECOM_QR_CODE = "wecom_qr_code";

    public static final String GUEST_RECOMMEND = "guest_recommend";

    public static final String DELETED = "deleted";

    public static final String ACTIVITY_STATUS = "activity_status";

    public static final String OVERT_STATUS = "overt_status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public boolean isDiscountApplied() {
        Integer discountLimitType = this.getDiscountLimitType();
        if (Constants.DiscountLimitType.DATE == (discountLimitType)) {
            LocalDateTime now = LocalDateTime.now();
            return this.getDiscountStartTime() != null
                    && this.getDiscountEndTime() != null
                    && !now.isBefore(this.getDiscountStartTime())
                    && !now.isAfter(this.getDiscountEndTime());
        }
        return Constants.DiscountLimitType.COUNT == (discountLimitType) && this.getDiscountRegisterCount() < this.getDiscountLimitCount();
    }
}
