package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动用户评价表
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ActivityEvaluation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 评价ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 评价-主持人得分
     */
    private Integer hostScore;

    /**
     * 评价-活动内容得分
     */
    private Integer contentScore;

    /**
     * 评价-嘉宾质量得分
     */
    private Integer guestQualityScore;

    /**
     * 评价-活动费用得分
     */
    private Integer costScore;

    /**
     * 评价-整体评价得分
     */
    private Integer overallScore;

    /**
     * 复参意愿 0-不愿意 1-愿意
     */
    private Integer reAttend;

    /**
     *  平均分
     */
    private BigDecimal avgScore;

    /**
     * 表扬点
     */
    private String praise;

    /**
     * 吐槽点
     */
    private String criticism;

    /**
     * 评价时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String ACTIVITY_ID = "activity_id";

    public static final String USER_ID = "user_id";

    public static final String HOST_SCORE = "host_score";

    public static final String CONTENT_SCORE = "content_score";

    public static final String GUEST_QUALITY_SCORE = "guest_quality_score";

    public static final String COST_SCORE = "cost_score";

    public static final String OVERALL_SCORE = "overall_score";

    public static final String RE_ATTEND = "re_attend";

    public static final String AVG_SCORE = "avg_score";

    public static final String PRAISE = "praise";

    public static final String CRITICISM = "criticism";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
