package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动负责人
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ActivityOrganizer implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 城市code
     */
    private String cityCode;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 身份信息
     */
    private String cardMessage;

    /**
     * 地址
     */
    private String address;

    /**
     * 支持活动类型，list类型的json字符串
     */
    private String supportActivityTypes;

    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String CITY_CODE = "city_code";

    public static final String NAME = "name";

    public static final String MOBILE = "mobile";

    public static final String CARD_MESSAGE = "card_message";

    public static final String ADDRESS = "address";

    public static final String SUPPORT_ACTIVITY_TYPES = "support_activity_types";

    public static final String DELETED = "deleted";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
