package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动报名表
 * </p>
 *
 * @author dll
 * @since 2025-06-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ActivityRegistration implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 1 男 0 女
     */
    private Integer gender;

    /**
     * 报名时间
     */
    private LocalDateTime registrationTime;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 活动报名状态 0-待支付 1-超时未支付 2-已报名成功 3-已取消/已退款
     */
    private Integer status;

    /**
     * 签到状态  0未签到 1 已签到
     */
    private Integer signInStatus;

    /**
     * 签到时间
     */
    private LocalDateTime signInTime;

    /**
     * 推送状态 0=否 1=是
     */
    private Integer pushStatus;

    /**
     * 是否享受优惠：0=否 1=是
     */
    private Integer discountApplied;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;

    /**
     * 免费报名活动类型id
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long freeActivityTypeId;

    /**
     * 1删除 0不删除
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String ACTIVITY_ID = "activity_id";

    public static final String USER_ID = "user_id";

    public static final String GENDER = "gender";

    public static final String REGISTRATION_TIME = "registration_time";

    public static final String ORDER_NO = "order_no";

    public static final String STATUS = "status";

    public static final String SIGN_IN_STATUS = "sign_in_status";

    public static final String SIGN_IN_TIME = "sign_in_time";

    public static final String DISCOUNT_APPLIED = "discount_applied";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
