package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动类型表
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ActivityType implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 1 线上 2线下
     */
    private Integer type;

    /**
     * 活动业务类型 0-其他(非互选) 1-互选
     */
    private Integer bizType;

    /**
     * 活动类型名称
     */
    private String name;

    /**
     * 简介
     */
    private String intro;

    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String TYPE = "type";

    public static final String BIZ_TYPE = "biz_type";

    public static final String NAME = "name";

    public static final String INTRO = "intro";

    public static final String DELETED = "deleted";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
