package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动用户选择记录表
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ActivityUserSelection implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 选择人ID
     */
    private Long userId;

    /**
     * 被选择的用户ID
     */
    private Long targetUserId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 1删除 0不删除
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String ACTIVITY_ID = "activity_id";

    public static final String USER_ID = "user_id";

    public static final String TARGET_USER_ID = "target_user_id";

    public static final String CREATE_TIME = "create_time";

}
