package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author dll
 * @since 2025-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AiApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 应用名称
     */
    private String applicationName;

    /**
     * 应用介绍
     */
    private String applicationDescription;

    /**
     * 对应百炼应用ID
     */
    private String appId;

    /**
     * 业务空间ID
     */
    private String workspaceId;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private LocalDateTime modifyTime;

    @TableField(fill = FieldFill.INSERT)
    private String createUser;

    @TableField(fill = FieldFill.UPDATE)
    private String modifyUser;


    public static final String ID = "id";

    public static final String APPLICATION_NAME = "application_name";

    public static final String APPLICATION_DESCRIPTION = "application_description";

    public static final String APP_ID = "app_id";

    public static final String WORKSPACE_ID = "workspace_id";

    public static final String DELETED = "deleted";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
