package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 渠道管理
 * </p>
 *
 * @author dll
 * @since 2025-05-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AiChannel implements Serializable {

    private static final long serialVersionUID = 11124L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 父渠道ID
     */
    private Long parentChannelId;

    /**
     * 渠道code
     */
    private String channel;

    /**
     * 渠道类型（字典）
     */
    private String channelType;

    /**
     * 渠道类型名称（字典）
     */
    private String channelTypeName;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 落地页
     */
    private String url;

    /**
     * 公司名称
     */
    private String company;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 对接员工
     */
    private String bxmBd;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    private String createUser;

    private String modifyUser;


    public static final String ID = "id";

    public static final String PARENT_CHANNEL_ID = "parent_channel_id";

    public static final String CHANNEL = "channel";

    public static final String CHANNEL_TYPE = "channel_type";

    public static final String CHANNEL_TYPE_NAME = "channel_type_name";

    public static final String CHANNEL_NAME = "channel_name";

    public static final String URL = "url";

    public static final String COMPANY = "company";

    public static final String CONTACTS = "contacts";

    public static final String MOBILE = "mobile";

    public static final String EMAIL = "email";

    public static final String CONTRACT_NO = "contract_no";

    public static final String BXM_BD = "bxm_bd";

    public static final String DELETED = "deleted";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
