package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 事件管理表
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AiEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 事件类型ID
     */
    private Integer eventTypeId;

    /**
     * 应用id
     */
    private Long applicationId;

    /**
     * 事件名称
     */
    private String name;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 启用状态  0未启用 1启用
     */
    private Integer status;

    /**
     * 事件说明
     */
    private String instru;

    /**
     * 背景
     */
    private String background;

    /**
     * 目标
     */
    private String target;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    private String createUser;

    private String modifyUser;


    public static final String ID = "id";

    public static final String EVENT_TYPE_ID = "event_type_id";

    public static final String APPLICATION_ID = "application_id";

    public static final String NAME = "name";

    public static final String DELETED = "deleted";

    public static final String STATUS = "status";

    public static final String INSTRU = "instru";

    public static final String BACKGROUND = "background";

    public static final String TARGET = "target";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
