package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 示例库
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AiExample implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 事件ID
     */
    private Long eventId;

    /**
     * 对话人ID
     */
    private Long interlocutorsId;

    /**
     * 资料状态模版ID
     */
    private Long dataTemId;

    /**
     * 社交状态模版ID
     */
    private Long socializeTemId;

    /**
     * 付费状态模版ID
     */
    private Long payTemId;

    /**
     * 活跃状态模版ID
     */
    private Long actTemId;

    /**
     * 聊天数量
     */
    private Integer chatCount;

    /**
     * 聊天json
     */
    private String chatJson;

    /**
     * 示例标题
     */
    private String exampleTitle;

    /**
     * 示例标签
     */
    private String exampleTag;

    /**
     * 示例简介
     */
    private String exampleIntro;

    /**
     * 版本号
     */
    private Integer version;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    private String createUser;

    private String modifyUser;


    public static final String ID = "id";

    public static final String EVENT_ID = "event_id";

    public static final String INTERLOCUTORS_ID = "interlocutors_id";

    public static final String DATA_TEM_ID = "data_tem_id";

    public static final String SOCIALIZE_TEM_ID = "socialize_tem_id";

    public static final String PAY_TEM_ID = "pay_tem_id";

    public static final String ACT_TEM_ID = "act_tem_id";

    public static final String CHAT_COUNT = "chat_count";

    public static final String CHAT_JSON = "chat_json";

    public static final String EXAMPLE_TITLE = "example_title";

    public static final String EXAMPLE_TAG = "example_tag";

    public static final String EXAMPLE_INTRO = "example_intro";

    public static final String VERSION = "version";

    public static final String DELETED = "deleted";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
