package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 对话人管理
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AiInterlocutors implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 昵称
     */
    private String nickeName;

    /**
     * 性别  1男 2女
     */
    private Integer sex;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 特质模版ID
     */
    private Long templateId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    private String createUser;

    private String modifyUser;


    public static final String ID = "id";

    public static final String NICKE_NAME = "nicke_name";

    public static final String SEX = "sex";

    public static final String DELETED = "deleted";

    public static final String AGE = "age";

    public static final String TEMPLATE_ID = "template_id";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
