package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 模版管理
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AiTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Integer type;

    /**
     * 名称
     */
    private String name;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 说明
     */
    private String instru;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    private String createUser;

    private String modifyUser;


    public static final String ID = "id";

    public static final String TYPE = "type";

    public static final String NAME = "name";

    public static final String DELETED = "deleted";

    public static final String INSTRU = "instru";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
