package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户的聊天会话
 * </p>
 *
 * @author Allen Hu
 * @since 2025-06-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ChatSession implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 会话名称
     */
    private String sessionName;

    /**
     * 场景类型 1.默认 2.企微
     */
    private Integer sceneType;

    /**
     * 扩展参数 如 scene_type=2时为unionId
     */
    private String ext;

    /**
     * 扣子的机器人ID
     */
    private String cozeBotId;

    /**
     * 扣子的会话ID
     */
    private String cozeConversationId;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String USER_ID = "user_id";

    public static final String SESSION_NAME = "session_name";

    public static final String COZE_BOT_ID = "coze_bot_id";

    public static final String COZE_CONVERSATION_ID = "coze_conversation_id";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String DELETED = "deleted";

}
