package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户的聊天会话的消息记录
 * </p>
 *
 * @author Allen
 * @since 2025-06-30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class ChatSessionMessage implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 会话ID
     */
    private Long sessionId;

    /**
     * 说话人角色：user / assistant / staff / ui
     */
    private String role;

    /**
     * 消息类型。0 截断符号、1 文本消息、2 图文、3 用户卡片
     */
    private Integer contentType;

    /**
     * 推理内容
     */
    private String reasoningContent;

    /**
     * 正文内容
     */
    private String content;

    /**
     * 附件内容，JSON数据，一般根据消息类型来定义自己的数据模型
     */
    private String attachments;

    private LocalDateTime createTime;


    public static final String ID = "id";

    public static final String SESSION_ID = "session_id";

    public static final String ROLE = "role";

    public static final String CONTENT_TYPE = "content_type";

    public static final String REASONING_CONTENT = "reasoning_content";

    public static final String CONTENT = "content";

    public static final String ATTACHMENTS = "attachments";

    public static final String CREATE_TIME = "create_time";

}
