package com.bxm.lovelink.common.dal.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户的聊天会话的消息反馈
 * </p>
 *
 * @author Allen Hu
 * @since 2025-06-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ChatSessionMessageFeedback implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long sessionMessageId;

    /**
     * 反馈状态 -1 负面的 1 满意的
     */
    private Integer feedbackStatus;

    private LocalDateTime createTime;


    public static final String SESSION_MESSAGE_ID = "session_message_id";

    public static final String FEEDBACK_STATUS = "feedback_status";

    public static final String CREATE_TIME = "create_time";

}
