package com.bxm.lovelink.common.dal.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zhangdong
 * @date 2025/6/13
 */
@Data
@Accessors(chain = true)
public class DecorationScoreDetail implements Serializable {
    /**
     * 类型 1我的信息 2理想伴侣 3相册 4关于我 5恋爱目标 6头像/昵称 7我的声音
     */
    @NotNull(message = "类型不能为空")
    private Integer type;
    /**
     * 分数
     */
    @NotNull(message = "分数不能为空")
    @Range(min = 0, max = 100, message = "分数必须在0-100之间")
    private Integer score;
}
