package com.bxm.lovelink.common.dal.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhangdong
 * @date 2025/5/17
 */
@Data
@Accessors(chain = true)
public class FlowControl {

    public static long PERSIST = -1;
    public static long NO_TIME = -2;

    /**
     * redis Key
     */
    private String redisKey;
    /**
     * 计数过期时间 单位 秒
     */
    private long countExpireTime;
    /**
     * 限制的过期时间  单位 秒
     * 负数 >=0 代表限制一段时间 -1代表永久限制 -2代表不处理
     */
    private long limitExpireTime = NO_TIME;
    /**
     * 计数阈值
     */
    private long countThreshold;

    public boolean check() {
        return StringUtils.isNotBlank(redisKey)
                && countExpireTime > 0;
    }
}
