package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 版本管理
 * </p>
 *
 * @author dll
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class LovelinkAppVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 渠道类型
     */
    private String channel;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 历史版本
     */
    private String version;

    /**
     * 是否强制更新  0 不强制  1强制
     */
    private Integer isUpdate;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    private String createUser;

    private String modifyUser;


    public static final String ID = "id";

    public static final String CHANNEL = "channel";

    public static final String CHANNEL_NAME = "channel_name";

    public static final String VERSION = "version";

    public static final String IS_UPDATE = "is_update";

    public static final String DELETED = "deleted";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CREATE_USER = "create_user";

    public static final String MODIFY_USER = "modify_user";

}
