package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 见面群
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MeetGroup implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 邀请人
     */
    private Long inviteUserId;

    /**
     * 接受人
     */
    private Long acceptUserId;

    /**
     * 邀请函内容
     */
    private String inviteMessage;

    /**
     * 邀请人已读状态。0 未读、1 已读
     */
    private Integer inviteUserReadMark;

    /**
     * 接收人已读状态。0 未读、1 已读
     */
    private Integer acceptUserReadMark;

    /**
     * 群状态。0 发出了邀请、-1 拒绝、-2 举报、2 同意沟通中、3 沟通结束不见面、4 见面成功、5 见面失败、-3 邀请超时
     */
    private Integer groupStatus;

    /**
     * 举报或拒绝原因
     */
    private String rejectMeetReason;

    /**
     * 见面需要多少颗红豆
     */
    private Integer meetNeedTicketCount;

    /**
     * 邀请方需要的红豆数量
     */
    private Integer meetInviteNeedTicketCount;

    /**
     * 接受方需要的红豆数量
     */
    private Integer meetAcceptNeedTicketCount;

    /**
     * 邀请方使用的红豆数量
     */
    private Integer meetInviteUseTicketCount;

    /**
     * 接受方使用的红豆数量
     */
    private Integer meetAcceptUseTicketCount;

    /**
     * 选择约会时间地点的用户ID
     */
    private Long meetSelectAddressUserId;

    /**
     * 见面状态：0 等待选择约会时间和地点、1 等待确认、2 已确认
     */
    private Integer meetStatus;

    /**
     * 见面地址
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String meetAddress;

    /**
     * 期望的见面时间段，多个用英文逗号隔开。如：2025-11-12 09:00-10:00,2025-11-13 09:00-10:00
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String meetExceptTimes;

    /**
     * 确定见面时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String meetTime;

    /**
     * 见面开始时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalDateTime meetTimeStart;

    /**
     * 见面结束时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalDateTime meetTimeEnd;

    /**
     * 邀请人是否确认见面，0 未见面、1 已见面
     */
    private Integer meetInviteUserResult;

    private String meetInviteUserResultDesc;

    /**
     * 接收人是否确认见面，0 未见面、1 已见面
     */
    private Integer meetAcceptUserResult;

    private String meetAcceptUserResultDesc;

    /**
     * 邀请超时时间
     */
    private LocalDateTime inviteExpireTime;

    /**
     * 推送次数
     */
    private Integer pushCount;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 删除标识
     */
    private Integer deleted;

    public static final String ID = "id";

    public static final String INVITE_USER_ID = "invite_user_id";

    public static final String ACCEPT_USER_ID = "accept_user_id";

    public static final String INVITE_MESSAGE = "invite_message";

    public static final String INVITE_USER_READ_MARK = "invite_user_read_mark";

    public static final String ACCEPT_USER_READ_MARK = "accept_user_read_mark";

    public static final String GROUP_STATUS = "group_status";

    public static final String REJECT_MEET_REASON = "reject_meet_reason";

    public static final String MEET_NEED_TICKET_COUNT = "meet_need_ticket_count";

    public static final String MEET_INVITE_NEED_TICKET_COUNT = "meet_invite_need_ticket_count";

    public static final String MEET_ACCEPT_NEED_TICKET_COUNT = "meet_accept_need_ticket_count";

    public static final String MEET_INVITE_USE_TICKET_COUNT = "meet_invite_use_ticket_count";

    public static final String MEET_ACCEPT_USE_TICKET_COUNT = "meet_accept_use_ticket_count";

    public static final String MEET_SELECT_ADDRESS_USER_ID = "meet_select_address_user_id";

    public static final String MEET_STATUS = "meet_status";

    public static final String MEET_ADDRESS = "meet_address";

    public static final String MEET_EXCEPT_TIMES = "meet_except_times";

    public static final String MEET_TIME = "meet_time";

    public static final String MEET_TIME_START = "meet_time_start";

    public static final String MEET_TIME_END = "meet_time_end";

    public static final String MEET_INVITE_USER_RESULT = "meet_invite_user_result";
    public static final String MEET_INVITE_USER_RESULT_DESC = "meet_invite_user_result_desc";

    public static final String MEET_ACCEPT_USER_RESULT = "meet_accept_user_result";
    public static final String MEET_ACCEPT_USER_RESULT_DESC = "meet_accept_user_result_desc";

    public static final String INVITE_EXPIRE_TIME = "invite_expire_time";

    public static final String PUSH_COUNT = "push_count";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String DELETED = "deleted";

}
