package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 见面群聊天记录
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MeetGroupMessage implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long meetGroupId;

    /**
     * 说话人角色：user / assistant
     */
    private String role;

    /**
     * 说话人。如果是assistant，则为空
     */
    private Long userId;

    /**
     * 消息类型。1 文本消息
     */
    private Integer contentType;

    private String content;

    private LocalDateTime createTime;


    public static final String ID = "id";

    public static final String MEET_GROUP_ID = "meet_group_id";

    public static final String ROLE = "role";

    public static final String USER_ID = "user_id";

    public static final String CONTENT_TYPE = "content_type";

    public static final String CONTENT = "content";

    public static final String CREATE_TIME = "create_time";

}
