package com.bxm.lovelink.common.dal.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 见面群聊天记录已读情况
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MeetGroupMessageReadMark implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 群ID
     */
    private Long meetGroupId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 已读的最后一条消息ID
     */
    private Long lastReadMessageId;


    public static final String MEET_GROUP_ID = "meet_group_id";

    public static final String USER_ID = "user_id";

    public static final String LAST_READ_MESSAGE_ID = "last_read_message_id";

}
