package com.bxm.lovelink.common.dal.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 红豆商品
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MeetTicketProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 类型。1 红豆充值、2 vip卡、 3 付费认证
     */
    private Integer productType;

    /**
     * 原价
     */
    private BigDecimal marketPrice;

    /**
     * 优惠价
     */
    private BigDecimal discountPrice;

    /**
     * 折扣率 0.8=8折
     */
    private BigDecimal discountRate;

    /**
     * 红豆数量
     */
    private Integer amount;

    /**
     * 红豆有效天数，如果等于0表示不限
     */
    private Integer ticketValidDays;

    /**
     * vip有效天数，如果等于0表示不限
     */
    private Integer vipValidDays;

    /**
     * 渠道，多个用英文逗号隔开，为空表示所有渠道
     */
    private String channelList;

    /**
     * 描述
     */
    private String description;

    /**
     * 解释标签
     */
    private String commentTags;

    /**
     * 状态。0 禁用、1 启用
     */
    private Integer status;

    /**
     * vip是否自动续费，1 是，0 否
     */
    private Integer isAutoRenew;

    /**
     * Apple IAP 商品ID
     */
    private String appleProductId;

    /**
     * 创建人
     */
    private String createUser;

    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    private LocalDateTime modifyTime;

    /**
     * 删除标识
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String NAME = "name";

    public static final String PRODUCT_TYPE = "product_type";

    public static final String MARKET_PRICE = "market_price";

    public static final String DISCOUNT_PRICE = "discount_price";

    public static final String DISCOUNT_RATE = "discount_rate";

    public static final String AMOUNT = "amount";

    public static final String TICKET_VALID_DAYS = "ticket_valid_days";

    public static final String VIP_VALID_DAYS = "vip_valid_days";

    public static final String CHANNEL_LIST = "channel_list";

    public static final String DESCRIPTION = "description";

    public static final String COMMENT_TAGS = "comment_tags";

    public static final String STATUS = "status";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

    public static final String DELETED = "deleted";

}
