package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 推送任务配置
 * </p>
 *
 * @author dll
 * @since 2025-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PushTask implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 1 即时任务  2定时任务
     */
    private Integer taskType;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务场景
     */
    private String taskScene;

    /**
     * 任务逻辑描述，相同场景的逻辑相同，新增场景需要提前开发好后才能用。比如：在用户注册后3小时<100%完成资料填写则触发推送
     */
    private String taskLogicDesc;

    /**
     * 1、ID，2、场景。表示同一ID下计算推送次数或同一场景下计算推送次数。
     */
    private Integer taskCountRange;

    /**
     * 生命结束期 以天为单位
     */
    private Long taskEndOfLife;

    /**
     * 任务场景的特定配置  比如：超时1、3、6小时；留存的n天。
     */
    private String taskSceneCustomConfig;

    /**
     * 推送标题等
     */
    private String pushTitle;

    /**
     * 用户收到的消息内容
     */
    private String pushMessage;

    /**
     * 推送业务内容，比如跳转的路径等
     */
    private String pushPayload;

    /**
     * 推送最大次数，一般指同一个周期内
     */
    private Integer pushMaximumCount;

    /**
     * 沉默时间（就是任务周期），单位：小时
     */
    private Integer pushCycleHours;

    /**
     * 状态  0 关闭  1 启用
     */
    private Integer status;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String TASK_TYPE = "task_type";

    public static final String TASK_NAME = "task_name";

    public static final String TASK_SCENE = "task_scene";

    public static final String TASK_LOGIC_DESC = "task_logic_desc";

    public static final String TASK_COUNT_RANGE = "task_count_range";

    public static final String TASK_END_OF_LIFE = "task_end_of_life";

    public static final String TASK_SCENE_CUSTOM_CONFIG = "task_scene_custom_config";

    public static final String PUSH_TITLE = "push_title";

    public static final String PUSH_MESSAGE = "push_message";

    public static final String PUSH_PAYLOAD = "push_payload";

    public static final String PUSH_MAXIMUM_COUNT = "push_maximum_count";

    public static final String PUSH_CYCLE_HOURS = "push_cycle_hours";

    public static final String STATUS = "status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
