package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 区域表
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("region")
public class Region implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 区域编码
     */
    @TableId(value = "code", type = IdType.AUTO)
    private Integer code;

    /**
     * 名字
     */
    private String name;

    /**
     * 别名
     */
    private String alias;
    /**
     * 首字母
     */
    private String firstLetter;
    /**
     * 父级编码
     */
    private Integer parentCode;

    /**
     * 全名
     */
    private String fullName;


}
