package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * <p>
 * 用户账号信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("user")
public class User implements Serializable {

    public static final Integer REGISTER_FINISHED_YES = 1;
    public static final Integer REGISTER_FINISHED_NO = 0;

    public static final Integer STATUS_NORMAL = 1;

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 用户编号
     */
    private String userNumber;
    /**
     * openid
     */
    private String openid;

    /**
     * unionid
     */
    private String unionid;
    /**
     * apple用户id
     */
    private String appleUserId;
    /**
     * uni用户id
     */
    private String uniUserId;
    /**
     * 渠道code
     */
    private String channel;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 用户状态 -1 禁用、1 正常
     */
    private Integer status;
    /**
     * 是否注册完成 1是 0 否
     */
    private Integer registerFinished;


    /**
     * 最后一次在线时间
     */
    private LocalDateTime lastOnLineTime;

    /**
     * 注册完成时间
     */
    private LocalDateTime registerFinishTime;
    /**
     * 推送ID
     */
    private String pushClientid;
    /**
     * 注销原因
     */
    private String cancelReason;
    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


    public boolean isNormal() {
        return STATUS_NORMAL.equals(status);
    }

    public boolean isRegisterFinish() {
        return Objects.equals(registerFinished, REGISTER_FINISHED_YES);
    }

}
