package com.bxm.lovelink.common.dal.entity;


import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 用户行为
 * @author: weixing
 */
@Data
@Accessors(chain = true)
public class UserAction {
    /**
     * 退款
     */
    public static final Integer REFUND = -1;

    /**
     * 注册
     */
    public static final Integer REGISTER = 1;

    /**
     * 消费
     */
    public static final Integer CONSUME = 2;

    /**
     * 激活
     */
    public static final Integer ACTIVATION = 3;

    /**
     * 婚姻认证
     */
    public static final Integer MARRIAGE= 4;

    /**
     * 学历认证
     */
    public static final Integer EDUCATION = 5;

    /**
     * 用户资料完善>=80%
     */
    public static final Integer INFO_COMPLETE = 6;

    /**
     * 用户资料引导完成
     */
    public static final Integer INFO_GUIDE_FINISH = 8;

    /**
     * 用户ID
     */
    private  Long userId;

    /**
     * 行为类型
     */
    private Integer type;

    /**
     * 充值消费订单号
     */
    private String orderNum;

    /**
     * 订单金额
     */
    private BigDecimal amount;

    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;

    /**
     * 婚姻 2未婚、4离异、8丧偶
     */
    private Integer marriage;

}
