package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * <p>
 * 用户资料审核
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("user_audit")
public class UserAudit implements Serializable {
    public static final Integer TYPE_IMAGE = 1;
    public static final Integer TYPE_VIDEO = 2;

    public static final Integer AUDIT_BUSINESS_AVATAR = 1;

    public static final Integer AUDIT_AUTO = 1;

    public static final Integer STATUS_WAIT = 0;
    public static final Integer STATUS_AUDITING = 1;
    public static final Integer STATUS_PASS = 2;
    public static final Integer STATUS_FAIL = -1;

    public static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long userId;

    /**
     * 审核业务 1用户头像
     */
    private Integer auditBusiness;

    /**
     * 审核自动化：1 自动
     */
    private Integer auditAuto;

    /**
     * 审核类型：1 图片、2 视频
     */
    private Integer auditType;

    /**
     * 审核内容
     */
    private String auditContent;

    /**
     * 认证状态：0 待审核、1 审核中、2 审核通过、-1 审核失败
     */
    private Integer auditStatus;
    /**
     * 关联的外部id
     */
    private Long connectId;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    public boolean isWait() {
        return Objects.equals(UserAudit.STATUS_WAIT, auditStatus) || Objects.equals(UserAudit.STATUS_AUDITING, auditStatus);
    }

}
