package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.handler.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 用户的基本信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_basic_info", autoResultMap = true)
public class UserBasicInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long userId;

    /**
     * 1 男 0 女
     */
    private Integer gender;
    /**
     * 生日
     */
    private LocalDate birthday;
    /**
     * 生肖
     */
    private Integer zodiac;
    /**
     * 星座
     */
    private Integer constellation;
    /**
     * 身高 cm
     */
    private Integer height;
    /**
     * 现居地 区code
     */
    private Integer currentPlaceDistrict;
    /**
     * 籍贯 区code
     */
    private Integer nativePlaceDistrict;
    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;
    /**
     * 学校名称
     */
    private String schoolName;
    /**
     * 学校是否隐藏 1隐藏、0显示
     */
    private Integer schoolHide;
    /**
     * 行业
     */
    private String industry;
    /**
     * 工作
     */
    private String job;
    /**
     * 年收入 2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private Integer yearRevenue;
    /**
     * 婚姻 2未婚、4离异、8丧偶
     */
    private Integer marriage;
    /**
     * 子女 2无子女、4一个儿子、8一个女儿、16一儿一女、32 两个儿子 64 两个女儿、128 两个以上子女
     */
    private Integer children;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 原始图片
     */
    private String originalImage;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 头像压缩
     */
    private String avatarCompress;
    /**
     * 卡片图
     */
    private String cardImage;
    /**
     * 恋爱目标 1没考虑清楚、2短期内想结婚、4先认真谈场恋爱、8先认真谈场恋爱，合适可以结婚
     */
    private Integer loveGoal;
    /**
     * 纹身状态 2小面积或者隐私部位、4大面积明显部位、8没纹身
     */
    private Integer tattooStatus;
    /**
     * 吸烟情况 2偶尔抽烟、4抽烟、8不抽烟
     */
    private Integer smokeStatus;
    /**
     * 房子情况 2、有房，4、无房
     */
    private Integer house;
    /**
     * 房子情况 所在市
     */
    private Integer houseCity;
    /**
     * 车情况 2、有车，4、无车
     */
    private Integer car;
    /**
     * 关于我 列表["介绍1","介绍2","介绍3"]
     */
    @TableField(typeHandler = UserAboutMeListTypeHandler.class)
    private List<UserAboutMe> aboutMe;

    /**
     * 相册 列表["img1url","img2url"]
     */
    @TableField(typeHandler = UserAlbumListTypeHandler.class)
    private List<UserAlbum> album;
    /**
     * 声音
     */
    private String voice;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 纬度
     */
    private Double latitude;
    /**
     * 最后登录地区
     */
    private Integer lastLoginDistrict;
    /**
     * 规则标签 列表
     */
    @TableField(typeHandler = UserRuleTagListTypeHandler.class)
    private List<UserRuleTag> ruleTag;
    /**
     * 隐藏标签 列表
     */
    @TableField(typeHandler = UserRuleTagListTypeHandler.class)
    private List<UserRuleTag> hideTag;
    /**
     * 兴趣标签 列表 [1,2,3]
     */
    @TableField(typeHandler = LongListTypeHandler.class)
    private List<Long> interestTag;
    /**
     * 用户资料认证进度，百分比
     */
    private Integer infoCertProgress;
    /**
     * 用户资料完成进度，百分比
     */
    private Integer infoCompleteProgress;
    /**
     * vip过期时间 不为空且时间>当前时间为vip
     */
    private LocalDateTime vipExpireTime;

    /**
     * 微信号
     */
    private String wechatNumber;
    /**
     * 认证状态 1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> certStatus;
    /**
     * 体型
     */
    private Integer bodyShape;
    /**
     * 信息完成状态 4除了理想伴侣没完成 5都完成
     */
    private Integer infoCompleteStatus;
    /**
     * 信任度
     */
    private Integer trustPercent;
    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;


    public boolean isMan() {
        return Objects.equals(gender, 1);
    }

    public boolean isSchoolDisplay() {
        return Objects.equals(schoolHide, 0);
    }

    /**
     * 获取取反性别
     */
    public Integer getReverseGender() {
        return Objects.equals(gender, Constants.UserGender.MALE) ? Constants.UserGender.FEMALE : Constants.UserGender.MALE;
    }

    public boolean declareNoCar() {
        return Objects.equals(car, UserConstants.CarEnum.NO_CAR.getCode());
    }
}
