package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.handler.AesEncDecHandler;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户资料认证
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_cert", autoResultMap = true)
public class UserCert implements Serializable {

    public static final int size = 5;

    private static final long serialVersionUID = 1L;

    public static final Integer TYPE_REAL_NAME = UserConstants.CertTypeEnum.REAL_PEOPLE.getCode();
    public static final Integer TYPE_EDUCATION = UserConstants.CertTypeEnum.EDU.getCode();
    public static final Integer TYPE_MARRIAGE = UserConstants.CertTypeEnum.MARRIED.getCode();
    public static final Integer TYPE_HOUSE = UserConstants.CertTypeEnum.HOUSE.getCode();
    public static final Integer TYPE_CAR = UserConstants.CertTypeEnum.CAR.getCode();

    public static final Integer STATUS_WAITING = 0;
    public static final Integer STATUS_CHECKING = 1;
    public static final Integer STATUS_PASS = 2;
    public static final Integer STATUS_FAIL = -1;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long userId;

    /**
     * 认证类别：1 实名、2 学历、4婚姻、8 房产、16 汽车
     */
    private Integer certType;

    /**
     * 认证内容
     */
    @TableField(typeHandler = AesEncDecHandler.class)
    private String certContent;

    /**
     * 认证结果
     */
    private String certResult;

    /**
     * 认证状态：0 待认证、1 认证中、2 认证通过、-1 认证失败
     */
    private Integer certStatus;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    public boolean isRealName() {
        return TYPE_REAL_NAME.equals(certType);
    }

    public boolean isWaiting() {
        return STATUS_WAITING.equals(certStatus) || STATUS_CHECKING.equals(certStatus);
    }

    public boolean isSuccess() {
        return STATUS_PASS.equals(certStatus);
    }

    public boolean isSuccessWithCarNum() {
        // 这里判断车辆认证需要是数量>0 才成功
        if (STATUS_PASS.equals(certStatus) && TYPE_CAR.equals(certType) && StringUtils.isNotBlank(certResult)) {
            return JsonHelper.convert(certResult, UserCertResult.class).getCarNum() > 0;
        }
        return STATUS_PASS.equals(certStatus);
    }

    public boolean isByApi() {
        return !isRealName();
    }

    public boolean isUnMarried() {
        if (StringUtils.isBlank(certResult)) {
            return false;
        }
        return STATUS_PASS.equals(certStatus) && TYPE_MARRIAGE.equals(certType) && JsonHelper.convert(certResult, UserCertResult.class).getStatus() == Constants.NO;
    }

    public Integer getEduHighest() {
        if (StringUtils.isBlank(certResult)) {
            return null;
        }
        UserCertResult result = JsonHelper.convert(certResult, UserCertResult.class);
        String eduLevel = result.getEducationLevel();
        return Constants.mapEducationLevel(eduLevel);
    }
}
