package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.handler.DecorationScoreDetailListTypeHandler;
import com.bxm.lovelink.common.handler.IntegerListTypeHandler;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户cms信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_cms", autoResultMap = true)
public class UserCms implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final Integer AUDIT_STATUS_FINISH = 1;
    public static final Integer AUDIT_STATUS_WAIT = 0;
    public static final Integer COMPLIANCE_STATUS_COMPLIANT = 1;
    public static final Integer COMPLIANCE_STATUS_NON_COMPLIANT = 0;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 审核状态 0待审核 1审核完成
     */
    private Integer auditStatus;

    /**
     * 合规 0不合规 1合规
     */
    private Integer complianceStatus;
    /**
     * 不合规原因
     */
    @TableField(typeHandler = IntegerListTypeHandler.class)
    private List<Integer> complianceNoReason;
    /**
     * 颜值等级  1一般 2普通 3优质
     */
    private Integer appearanceLevel;
    /**
     * 装修得分 满分100
     */
    private Integer decorationScore;
    /**
     * 装修得分明细
     */
    @TableField(typeHandler = DecorationScoreDetailListTypeHandler.class)
    private List<DecorationScoreDetail> decorationScoreDetail;

    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


}
