package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.handler.BitIntegerListTypeHandler;
import com.bxm.lovelink.common.handler.IntegerListTypeHandler;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户理想伴侣信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_love_condition",autoResultMap = true)
public class UserLoveCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long userId;

    /**
     * 年龄范围 最小值
     */
    private Integer ageRangeMin;

    /**
     * 年龄范围 最大值
     */
    private Integer ageRangeMax;
    /**
     * 身高范围 最小值
     */
    private Integer heightRangeMin;
    /**
     * 身高范围 最大值
     */
    private Integer heightRangeMax;
    /**
     * 学历 按位或运算 1不限、2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> eduRange;

    /**
     * 学校范围 按位或运算 1不限、2 985 211院校
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> schoolRange;

    /**
     * 婚姻孩子范围 按位或运算 1不限、2未婚、4离异 无子女、8离异 一个女儿、16离异 一个儿子、32离异 多个子女、64丧偶 无子女、128丧偶有子女
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> marriageChildrenRange;

    /**
     * 婚姻孩子范围 按位或运算 1不限、2未婚、4离异 无子女、8离异 一个女儿、16离异 一个儿子、32离异 多个子女、64丧偶 无子女、128丧偶有子女
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> marriageChildrenRelaxRange;

    /**
     * 籍贯范围  列表 [1,2,3]
     */
    @TableField(typeHandler = IntegerListTypeHandler.class)
    private List<Integer> nativePlaceRange;

    /**
     * 恋爱目标范围  按位或运算 1没考虑清楚、2短期内想结婚、4先认真谈场恋爱、8先认真谈场恋爱，合适可以结婚
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> loveGoalRange;

    /**
     * 纹身情况范围 按位或运算 1不介意、2小面积或者隐私部位、4大面积明显部位、8不接受任何纹身
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> tattooStatusRange;

    /**
     * 吸烟情况范围 按位或运算 1不介意、2偶尔抽烟、4抽烟、8不接受抽烟
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> smokeStatusRange;

    /**
     * 行业情况 按位或运算 1无所谓、2同行、4非同行
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> industryRange;

    /**
     * 工作情况 按位或运算 1无所谓、2稳定工作、4创业经商
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> jobRange;

    /**
     * 生活情况 按位或运算 1无所谓、2顾家、4事业
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> lifeRange;

    /**
     * 年收入 按位或运算 1无所谓、2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> yearRevenueRange;
    /**
     * 车情况 按位或运算 1无所谓、2、有车，4、无车
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> carRange;
    /**
     * 房子情况 按位或运算 1无所谓、2、有房，4、无房
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> houseRange;
    /**
     * 体型
     */
    @TableField(typeHandler = IntegerListTypeHandler.class)
    private List<Integer> bodyShapeRange;
    /**
     * 其他需求 json格式
     */
    private String otherRange;
    /**
     * 资料完成进度，百分比
     */
    private Integer infoCompleteProgress;
    /**
     * 1删除 0不删除
     */
    private Integer deleted;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


}
