package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户红豆
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UserMeetTicket implements Serializable {

    public static final Integer STATUS_AVAILABLE = 1;
    public static final Integer STATUS_USED = 2;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private String ticketId;

    /**
     * 所属用户
     */
    private Long userId;

    /**
     * 总红豆数
     */
    private Integer totalAmount;

    /**
     * 剩余红豆数
     */
    private Integer remainAmount;

    /**
     * 过期时间
     */
    private LocalDateTime expireTime;

    /**
     * 使用的见面群
     */
    private Long meetGroupId;

    private Long meetTicketProductId;

    private String meetTicketProductName;

    /**
     * 价值：元
     */
    private BigDecimal price;

    /**
     * 状态：1 可用、2 已使用、3 冻结中
     */
    private Integer status;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 使用时间
     */
    private LocalDateTime useTime;

    /**
     * 删除标识
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String TICKET_ID = "ticket_id";

    public static final String USER_ID = "user_id";

    public static final String TOTAL_AMOUNT = "total_amount";

    public static final String REMAIN_AMOUNT = "remain_amount";

    public static final String EXPIRE_TIME = "expire_time";

    public static final String MEET_GROUP_ID = "meet_group_id";

    public static final String MEET_TICKET_PRODUCT_ID = "meet_ticket_product_id";

    public static final String MEET_TICKET_PRODUCT_NAME = "meet_ticket_product_name";

    public static final String PRICE = "price";

    public static final String STATUS = "status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String USE_TIME = "use_time";

    public static final String DELETED = "deleted";
}
