package com.bxm.lovelink.common.dal.entity;

import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户红豆记录
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_meet_ticket_record", autoResultMap = true)
public class UserMeetTicketRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 类型：1.支出、2.退回、3.红豆充值 、4.vip卡充值、5.完善资料赠送
     */
    private Integer type;

    /**
     * 分类 1.充值 2.支出 3.退回
     */
    private Integer category;

    /**
     * 关联外部id
     */
    private Long connectId;

    /**
     * 扩展信息，json格式
     */
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private UserTicketRecordExt extJson;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String USER_ID = "user_id";

    public static final String AMOUNT = "amount";

    public static final String TYPE = "type";

    public static final String CATEGORY = "category";

    public static final String CONNECT_ID = "connect_id";

    public static final String EXT_JSON = "ext_json";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
