package com.bxm.lovelink.common.dal.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Objects;

import com.bxm.lovelink.common.contant.Constants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户订单表
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UserOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 渠道
     */
    private String channel;

    /**
     * 订单 id
     */
    private String orderNum;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 红豆商品id
     */
    private Long meetTicketProductId;

    /**
     * 商品类型：1 红豆充值、2 vip卡 3、付费认证 4-活动付费
     */
    private Integer productType;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 商品描述，比如购买周期
     */
    private String productDesc;

    /**
     * 额度，比如红豆数量
     */
    private Integer productAmount;

    /**
     * 商品扩展信息，json格式
     */
    private String productExtJson;

    /**
     * 订单金额
     */
    private BigDecimal totalPrice;

    /**
     * 实付金额
     */
    private BigDecimal paymentAmount;

    /**
     * 0- 待支付、1- 支付中、2- 支付成功、3- 已关闭、4- 已取消、5-退款中、6-退款成功、7.退款失败
     */
    private Integer status;

    /**
     * 支付方式：1.支付宝 2.微信 3.Apple
     */
    private Integer payType;

    /**
     * 支付平台订单号
     */
    private String paymentId;

    /**
     * 苹果原始交易ID
     */
//    private String originalTransactionId;

    /**
     * 扩展类型
     */
    private Integer extType;

    /**
     * 扩展信息，json格式
     */
    private String extJson;

    private LocalDateTime createTime;

    /**
     * 订单支付时间
     */
    private LocalDateTime paymentTime;

    private LocalDateTime modifyTime;

    /**
     * 删除标识
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String CHANNEL = "channel";

    public static final String ORDER_NUM = "order_num";

    public static final String USER_ID = "user_id";

    public static final String MEET_TICKET_PRODUCT_ID = "meet_ticket_product_id";

    public static final String PRODUCT_TYPE = "product_type";

    public static final String PRODUCT_NAME = "product_name";

    public static final String PRODUCT_DESC = "product_desc";

    public static final String PRODUCT_AMOUNT = "product_amount";

    public static final String PRODUCT_EXT_JSON = "product_ext_json";

    public static final String TOTAL_PRICE = "total_price";

    public static final String PAYMENT_AMOUNT = "payment_amount";

    public static final String STATUS = "status";

    public static final String PAY_TYPE = "pay_type";

    public static final String PAYMENT_ID = "payment_id";

    public static final String ORIGINAL_TRANSACTION_ID = "original_transaction_id";

    public static final String EXT_TYPE = "ext_type";

    public static final String EXT_JSON = "ext_json";

    public static final String CREATE_TIME = "create_time";

    public static final String PAYMENT_TIME = "payment_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String DELETED = "deleted";

    public boolean isVipProduct() {
        return Objects.equals(productType, Constants.MeetTicketProduct.VIP);
    }

    public boolean permitRefund(){
        return Objects.equals(status,Constants.UserOrder.STATUS_SUCCESS) ||  Objects.equals(status,Constants.UserOrder.STATUS_REFUND_FAIL);
    }

    public boolean isWxOrAliPay(){
        return Objects.equals(payType, Constants.UserOrder.PayType.WX_PAY) || Objects.equals(payType, Constants.UserOrder.PayType.ALI_PAY);
    }

}
