package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.handler.BitIntegerListTypeHandler;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户其他信息
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_other_info", autoResultMap = true)
public class UserOtherInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long userId;

    /**
     * 被心动次数
     */
    private Integer passiveLoveCount;

    /**
     * 感情状态 0 单身、1 恋爱
     */
    private Integer loveStatus;

    /**
     * 与该用户恋爱中
     */
    private Long loveUserId;
    /**
     * app动画是否引导完成 1是 0 否
     */
    private Integer animationGuideFinished;

    /**
     * 基础信息是否引导完成 1是 0 否
     */
    private Integer basicInfoGuideFinished;

    /**
     * 扩展信息 json格式
     */
    private String extJson;
    /**
     * 注册地区code
     */
    private Integer registerPlaceDistrict;
    /**
     * 注册时候的ip
     */
    private String registerIp;
    /**
     * 注册ip地区code
     */
    private Integer registerIpPlaceDistrict;
    /**
     * 新用户 1是 0 否
     */
    private Integer newUser;
    /**
     * 在线状态 1在线 0离线
     */
    private Integer onlineStatus;
    /**
     * 当前用户聊天的对接角色：0 AI对接中、1 人类接管中
     */
    private Integer chatContactRole;
    /**
     * 完善信息赠送红豆的阶段
     */
    @TableField(typeHandler = BitIntegerListTypeHandler.class)
    private List<Integer> infoFinishGiveStage;
    /**
     * 1删除 0不删除
     */
    private Integer deleted;
    private LocalDateTime createTime;
    private LocalDateTime modifyTime;

}
