package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户反馈建议表
 * </p>
 *
 * @author dll
 * @since 2025-05-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class UserQuestion implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 渠道
     */
    private String channel;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 问题
     */
    private String question;

    /**
     * 状态0 待处理  1已经处理
     */
    private Integer status;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 删除状态 0未删除 1删除

     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String CHANNEL = "channel";

    public static final String USER_ID = "user_id";

    public static final String QUESTION = "question";

    public static final String STATUS = "status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String DELETED = "deleted";

}
