package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户关系表
 * </p>
 *
 * @author weixing
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("user_relation")
public class UserRelation implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户 ID
     */
    private Long userId;

    /**
     * 被心动用户 ID
     */
    private Long targetUserId;

    /**
     * 类型 0-未反馈 1= 心动，2= 不喜欢
     */
    private Integer type;

    /**
     * 是否匹配 0-未匹配 1-匹配成功
     */
    private Integer matched;

    /**
     * 关系来源 0-用户行为 1-红娘推荐 默认 0
     */
    private Integer relationSource;

    /**
     * 是否已读 0-未读 1-已读
     */
    private Integer readStatus;

    /**
     * 匹配分
     */
    private Integer matchScore;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    /**
     * 删除状态 0未删除 1删除
     */
    private Integer deleted;

    /**
     * 心动状态 0-非正式 1-正式
     */
    private Integer heartBeatStatus;


}
