package com.bxm.lovelink.common.dal.entity;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 红豆记录扩展
 * @author tangxiao
 * @since 2025-05-15
 */
@Data
@Accessors(chain = true)
public class UserTicketRecordExt {

    /**
     * 列表标题
     */
    private String title;

    /**
     * 详情标题
     */
    private String detailTitle;

    /**
     * 订单说明
     */
    private String description;

    /**
     * 红豆过期时间
     */
    private LocalDateTime ticketExpireTime;

    /**
     * VIP过期时间
     */
    private String vipExpireTime;

    /**
     * 支付时间（卡发放时间
     */
    private LocalDateTime inviteTime;

    /**
     * 退卡原因
     */
    private String returnReason;

    /**
     * 退回时间
     */
    private LocalDateTime returnTime;

    /**
     * 邀约信息 (邀约**相亲)
     */
    private String inviteContent;

    /**
     * 备注说明
     */
    private String remark;

    /**
     * 是否接受邀约 0.否 1.是
     */
    private Integer isMeetAccept;

    /**
     * 接收人已读状态。0 未读、1 已读
     */
    private Integer acceptUserReadMark;
}
