package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户访问记录表
 * </p>
 *
 * @author weixing
 * @since 2025-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "user_visit_record", autoResultMap = true)
public class UserVisitRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 访问者用户ID
     */
    private Long userId;

    /**
     * 被访问者用户ID
     */
    private Long targetUserId;

    /**
     * 访问次数
     */
    private Integer visitCount;

    /**
     * 最近访问时间
     */
    private LocalDateTime lastVisitTime;

    /**
     *  是否已读 0-未读 1-已读
     */
    private Integer readStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String USER_ID = "user_id";

    public static final String TARGET_USER_ID = "target_user_id";

    public static final String VISIT_COUNT = "visit_count";

    public static final String LAST_VISIT_TIME = "last_visit_time";

    public static final String READ_STATUS = "read_status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
