package com.bxm.lovelink.common.dal.entity.dao;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 *
 * @author tangxiao
 * @since 2025-06-28
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class ChatSessionDao extends ChatSession {

    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private String userNickname;

    /**
     * 头像
     */
    @TableField(exist = false)
    private String userAvatar;

    @TableField(exist = false)
    private String lastMessageContent;

    @TableField(exist = false)
    private LocalDateTime lastMessageTime;

    /**
     * 当前用户聊天的对接角色：0 AI对接中、1 人类接管中
     */
    @TableField(exist = false)
    private Integer chatContactRole;

    /**
     * 未读消息数量
     */
    private Integer unreadNum;
}
