package com.bxm.lovelink.common.dal.entity.dao;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * <p>
 * 见面群
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MeetGroupDao extends MeetGroup {

    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private UserBasicInfo inviteUserBasicInfo;

    @TableField(exist = false)
    private UserBasicInfo acceptUserBasicInfo;

    @TableField(exist = false)
    private User inviteUser;

    @TableField(exist = false)
    private User acceptUser;

    @TableField(exist = false)
    private String lastMessageContent;

    @TableField(exist = false)
    private LocalDateTime lastMessageTime;

    /**
     * 是否邀请超时
     * @return true：超时，false：未超时
     */
    public boolean isExpiredInInviteTimeOut() {
        LocalDateTime inviteExpireTime = this.getInviteExpireTime();
        return null != inviteExpireTime && LocalDateTime.now().isAfter(inviteExpireTime);
    }

    /**
     * 返回当前用户的信息
     * @param myUserId 当前用户ID
     * @return 当前用户的信息
     */
    public UserBasicInfo getME(Long myUserId) {
        if (myUserId.equals(getInviteUserId())) {
            return inviteUserBasicInfo;
        } else {
            return acceptUserBasicInfo;
        }
    }

    /**
     * 返回对方信息
     * @param myUserId 当前用户ID
     * @return 对方信息
     */
    public UserBasicInfo getTA(Long myUserId) {
        if (myUserId.equals(getInviteUserId())) {
            return acceptUserBasicInfo;
        } else {
            return inviteUserBasicInfo;
        }
    }

    /**
     * 设置线下见面的结果
     * @param userId 当前用户ID
     * @param meetResult 见面结果
     * @param desc 见面结果说明
     */
    public void updateMeetResultForMe(Long userId, Integer meetResult, String desc) {
        if (Objects.equals(userId, getInviteUserId())) {
            this.setMeetInviteUserResult(meetResult);
            this.setMeetInviteUserResultDesc(desc);
        } else if (Objects.equals(userId, getAcceptUserId())) {
            this.setMeetAcceptUserResult(meetResult);
            this.setMeetAcceptUserResultDesc(desc);
        }
    }
}
