package com.bxm.lovelink.common.dal.entity.dao.activity;


import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserVo;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author: weixing
 */
@Data
public class ActivityListDao {
    private Long id;
    /**
     * 城市 code
     */
    private String cityCode;
    /**
     * 活动名称
     */
    private String name;
    /**
     * 活动标题
     */
    private String title;
    /**
     * 活动简介
     */
    private String intro;
    /**
     * 头图
     */
    private String headImage;
    /**
     * 新用户免费 0-否 1-是
     */
    private Integer newUserFree;

    /**
     * 报名费用
     */
    private BigDecimal registerPrice;

    /**
     * 早鸟票价
     */
    private BigDecimal discountPrice;

    /**
     * 早鸟票方式：1-日期 2-名额
     */
    private Integer discountLimitType;

    /**
     * 早鸟票开始时间
     */
    private LocalDateTime discountStartTime;

    /**
     * 早鸟票结束时间
     */
    private LocalDateTime discountEndTime;

    /**
     * 早鸟票限制名额
     */
    private Integer discountLimitCount;
    /**
     * 活动上限人数
     */
    private Integer participantsLimit;

    /**
     * 男生上限人数
     */
    private Integer maleParticipantsLimit;

    /**
     * 女生上限人数
     */
    private Integer femaleParticipantsLimit;
    /**
     * 活动开始时间
     */
    private LocalDateTime activityStartTime;
    /**
     * 报名总人数
     */
    private Integer registeredCount;
    /**
     * 男生报名人数
     */
    private Integer maleRegisteredCount;
    /**
     * 女生报名人数
     */
    private Integer femaleRegisteredCount;

    /**
     * 活动结束时间
     */
    private LocalDateTime activityEndTime;

    /**
     * 活动报名开始时间
     */
    private LocalDateTime registerStartTime;

    /**
     * 活动报名结束时间
     */
    private LocalDateTime registerEndTime;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 详细活动地址
     */
    private String addressDetail;

    /**
     * 活动状态 0-未开始 1-进行中 2-已结束
     */
    private Integer status;

    /**
     * 用户评价状态 0-未评价 1已评价
     */
    private Integer evaluationStatus;

    /**
     * 活动报名状态 1-未报名 2-已报名 3-已退款
     */
    private Integer registerStatus;

    /**
     * 活动报名成员
     */
    private List<ActivityUserVo> activityUserList;

    /**
     * 封面图片 list类型的json字符串
     */
    private String coverImages;
}
