package com.bxm.lovelink.common.dal.entity.dao.heartbeat;

import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 *  心动列表
 *
 * @author weixing
 */
@Data
public class HeartBeatLisDao implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 用户 ID
     */
    private Long userId;

    /**
     * 用户编号
     */
    private String userNumber;

    /**
     * 头像
     */
    private String avatar;
    /**
     * 卡片图
     */
    private String cardImage;
    /**
     * 昵称
     */
    private String nickname;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 性别
     */
    private Integer gender;
    /**
     * 身高 cm
     */
    private Integer height;
    /**
     * 现居地 省code
     */
    private Integer currentPlaceProvince;
    /**
     * 现居地 市code
     */
    private Integer currentPlaceCity;

    /**
     * 现居地 区code
     */
    private Integer currentPlaceDistrict;

    /**
     * 星座
     */
    private Integer constellation;

    /**
     * 学历 0 其他、1中专、2大专、3本科、4硕士、5博士
     */
    private Integer eduHighest;

    /**
     * 工作
     */
    private String job;

    /**
     * 购房情况 1-有房 0-无房
     */
    private Integer house;

    /**
     * 购车情况 1-有车 0-无车
     */
    private Integer car;

    /**
     * 实名认证状态
     */
    private Integer authStatus;

    /**
     * 学历认证状态
     */
    private Integer eduAuthStatus;

    /**
     * 婚姻认证状态
     */
    private Integer maritalAuthStatus;

    /**
     * 规则标签
     */
    private List<UserRuleTag> ruleTag;

    /**
     * 距离，单位：m
     */
    private Integer distance;

    /**
     * 关系来源 0-用户行为 1-红娘推荐
     */
    private Integer relationSource;

    /**
     * 被心动次数
     */
    private Integer passiveLoveCount;

    /**
     * 匹配度
     */
    private BigDecimal matchScore;

    /**
     * 是否已读 0-未读 1-已读
     */
    private Integer readStatus;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 删除标识
     */
    private Integer deleted;

    /**
     * 是否匹配 0 - 未匹配 1 - 已匹配
     */
    private Integer matched;

    public Integer getCurrentPlaceProvince() {
        if (currentPlaceDistrict == null) {
            return null;
        }
        return currentPlaceDistrict / 10000 * 10000;
    }
    public Integer getCurrentPlaceCity() {
        if (currentPlaceDistrict == null) {
            return null;
        }
        return currentPlaceDistrict / 100 * 100;
    }
}
