package com.bxm.lovelink.common.dal.entity.dao.visit;


import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 访客列表
 * @author: weixing
 */
@Data
public class UserVisitorListDao {
    /**
     * id
     */
    private Long id;

    /**
     * 用户 ID
     */
    private Long userId;

    /**
     * 用户编号
     */
    private String userNumber;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 卡片图
     */
    private String cardImage;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 性别 1-男 0-女
     */
    private Integer gender;

    /**
     * 现居地 市
     */
    private Integer currentPlaceCity;

    /**
     * 现居地城市名称
     */
    private String currentPlaceCityName;
    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;

    /**
     * 工作
     */
    private String job;

    /**
     * 身高 cm
     */
    private Integer height;

    /**
     * 距离，单位：m
     */
    private Integer distance;

    /**
     * 房子情况 2、有房，4、无房
     */
    private Integer house;

    /**
     * 车情况 2、有车，4、无车
     */
    private Integer car;

    /**
     * 是否已读 0-未读 1-已读
     */
    private Integer readStatus;

    /**
     * 删除标识 1-删除 0-正常
     */
    private Integer deleted;

    /**
     * 被心动次数
     */
    private Integer passiveLoveCount;

    /**
     * 匹配度
     */
    private BigDecimal matchScore;

    /**
     * 访问次数
     */
    private Integer visitCount;

    /**
     * 最近访问时间
     */
    private LocalDateTime lastVisitTime;
}
