package com.bxm.lovelink.common.dal.entity.dto.activity;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author dll
 * @since 2025-04-28
 */
@Data
public class ActivityDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动ID
     */
    @NotNull(message = "id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /**
     * 头图
     */
    @NotBlank(message = "头图不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String headImage;

    /**
     * 城市code
     */
    @NotBlank(message = "城市不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String cityCode;

    /**
     * 活动类型ID
     */
    @NotNull(message = "活动类型不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private Long activityTypeId;

    /**
     * 活动负责人ID
     */
    @NotNull(message = "活动负责人不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private Long organizerId;

    /**
     * 活动名称
     */
    @NotBlank(message = "活动名称不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String name;

    /**
     * 活动副标题
     */
    @NotBlank(message = "活动副标题不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String title;

    /**
     * 活动简介
     */
    @NotBlank(message = "活动简介不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String intro;

    /**
     * 新用户免费 0-否 1-是
     */
    @NotNull(message = "新用户是否免费不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private Integer newUserFree;

    /**
     * 报名费用
     */
    @NotNull(message = "报名费用不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private BigDecimal registerPrice;

    /**
     * 早鸟票价
     */
    private BigDecimal discountPrice;

    /**
     * 早鸟票方式：1-日期 2-名额
     */
    private Integer discountLimitType;

    /**
     * 早鸟票开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime discountStartTime;

    /**
     * 早鸟票结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime discountEndTime;
    /**
     * 早鸟票限制名额
     */
    private Integer discountLimitCount;

    /**
     * 活动开始时间
     */
    @NotNull(message = "活动开始时间不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime activityStartTime;

    /**
     * 活动结束时间
     */
    @NotNull(message = "活动结束时间不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime activityEndTime;

    /**
     * 活动报名开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime registerStartTime;

    /**
     * 活动报名结束时间
     */
    @NotNull(message = "活动报名结束时间不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime registerEndTime;

    /**
     * 活动地址
     */
    @NotBlank(message = "活动地址不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String address;

    /**
     * 详细活动地址
     */
    private String addressDetail;

    /**
     * 活动上限人数
     */
    @NotNull(message = "活动上限人数不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private Integer participantsLimit;

    /**
     * 活动可见范围： 0 私有 1公开
     */
    @NotNull(message = "活动可见范围不能为空", groups = {InsertGroup.class,UpdateGroup.class})
    private Integer overtStatus;
    /**
     * 男生上限人数
     */
    private Integer maleParticipantsLimit;

    /**
     * 女生上限人数
     */
    private Integer femaleParticipantsLimit;


    /**
     * 活动介绍图片 list类型的json字符串
     */
    @NotBlank(message = "活动介绍图片不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String introImages;

    /**
     * 封面图片 list类型的json字符串
     */
    @NotBlank(message = "封面图片不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String coverImages;

    /**
     * 活动流程图片 list类型的json字符串
     */
    @NotBlank(message = "活动流程图片不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String flowImages;

    /**
     * 退款规则图片 list类型的json字符串
     */
    @NotBlank(message = "退款规则图片不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String refundPolicyImages;

    /**
     * 注意事项图片 list类型的json字符串
     */
    @NotBlank(message = "注意事项图片不能为空", groups = {InsertGroup.class, UpdateGroup.class})
    private String noticeImages;

    /**
     * 企微二维码 list类型的json字符串
     */
    private String wecomQrCode;


    public static void main(String[] args) {
        LocalDateTime now= LocalDateTime.now();
        System.out.println(JSON.toJSONString(now));
    }
}
