package com.bxm.lovelink.common.dal.entity.dto.activity.evaluation;


import lombok.Data;

import java.util.Objects;

/**
 * @author: weixing
 */
@Data
public class ActivityEvaluationDto {
    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 评价-主持人得分
     */
    private Integer hostScore;

    /**
     * 评价-活动内容得分
     */
    private Integer contentScore;

    /**
     * 评价-嘉宾质量得分
     */
    private Integer guestQualityScore;

    /**
     * 评价-活动费用得分
     */
    private Integer costScore;

    /**
     * 评价-整体评价得分
     */
    private Integer overallScore;

    /**
     * 复参意愿 0-不愿意 1-愿意
     */
    private Integer reAttend;

    /**
     * 表扬点
     */
    private String praise;

    /**
     * 吐槽点
     */
    private String criticism;

    /**
     * 是否跳过评价
     */
    private Boolean skip = false;

    public void validateEvaluation() {
        if (!skip){
            if (hostScore == null
                    && contentScore == null
                    && guestQualityScore == null
                    && costScore == null
                    && overallScore == null) {
                throw new IllegalArgumentException("至少需要选择一个选项");
            }
            if (Objects.isNull(reAttend)){
                throw new IllegalArgumentException("请选择复参意愿");
            }
        }
    }
}
